/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1201;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import mcinterface1201.BuilderEntityLinkedSeat;
import mcinterface1201.WrapperNBT;
import mcinterface1201.WrapperPlayer;
import mcinterface1201.WrapperWorld;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.Damage;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.baseclasses.RotationMatrix;
import minecrafttransportsimulator.entities.components.AEntityB_Existing;
import minecrafttransportsimulator.entities.instances.PartSeat;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONPotionEffect;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperEntity;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.systems.ConfigSystem;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.LeadItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class WrapperEntity
implements IWrapperEntity {
    private static final Map<Entity, WrapperEntity> entityClientWrappers = new HashMap<Entity, WrapperEntity>();
    private static final Map<Entity, WrapperEntity> entityServerWrappers = new HashMap<Entity, WrapperEntity>();
    protected final Entity entity;
    private AEntityB_Existing cachedEntityRiding;
    private final Point3D mutablePosition = new Point3D();
    private final Point3D mutableVelocity = new Point3D();
    private final RotationMatrix mutableOrientation = new RotationMatrix();
    private float lastPitchChecked;
    private float lastYawChecked;
    private float lastYawApplied;
    private float lastPitch;
    private float lastYaw;
    private final Point3D mutableSight = new Point3D();
    private final BoundingBox mutableBounds = new BoundingBox(new Point3D(), 0.0, 0.0, 0.0);

    public static WrapperEntity getWrapperFor(Entity entity) {
        if (entity instanceof Player) {
            return WrapperPlayer.getWrapperFor((Player)entity);
        }
        if (entity != null) {
            Map<Entity, WrapperEntity> entityWrappers = entity.m_9236_().f_46443_ ? entityClientWrappers : entityServerWrappers;
            WrapperEntity wrapper = entityWrappers.get(entity);
            if (wrapper == null || !wrapper.isValid() || entity != wrapper.entity) {
                wrapper = new WrapperEntity(entity);
                entityWrappers.put(entity, wrapper);
            }
            return wrapper;
        }
        return null;
    }

    protected WrapperEntity(Entity entity) {
        this.entity = entity;
    }

    public boolean equals(Object obj) {
        return this.entity.equals(obj instanceof WrapperEntity ? ((WrapperEntity)obj).entity : obj);
    }

    public int hashCode() {
        return this.entity.hashCode();
    }

    @Override
    public boolean isValid() {
        return this.entity != null && this.entity.m_6084_();
    }

    @Override
    public UUID getID() {
        return this.entity.m_20148_();
    }

    @Override
    public String getName() {
        return this.entity.m_7755_().getString();
    }

    @Override
    public AWrapperWorld getWorld() {
        return WrapperWorld.getWrapperFor(this.entity.m_9236_());
    }

    @Override
    public AEntityB_Existing getEntityRiding() {
        AEntityB_Existing entityRiding;
        if (this.cachedEntityRiding != null) {
            return this.cachedEntityRiding;
        }
        Entity mcEntityRiding = this.entity.m_20202_();
        if (mcEntityRiding instanceof BuilderEntityLinkedSeat && (entityRiding = ((BuilderEntityLinkedSeat)mcEntityRiding).entity) != null && this.equals(entityRiding.rider)) {
            return entityRiding;
        }
        return null;
    }

    @Override
    public void setRiding(AEntityB_Existing entityToRide) {
        if (entityToRide != null) {
            AEntityB_Existing entityRiding = this.getEntityRiding();
            if (entityRiding == null) {
                if (!this.entity.m_9236_().f_46443_) {
                    BuilderEntityLinkedSeat seat = new BuilderEntityLinkedSeat((EntityType<? extends BuilderEntityLinkedSeat>)((EntityType)BuilderEntityLinkedSeat.E_TYPE3.get()), ((WrapperWorld)entityToRide.world).world);
                    seat.loadedFromSavedNBT = true;
                    seat.m_6034_(entityToRide.position.x, entityToRide.position.y, entityToRide.position.z);
                    seat.entity = entityToRide;
                    this.entity.m_9236_().m_7967_((Entity)seat);
                    this.entity.m_7998_((Entity)seat, true);
                }
            } else {
                ((BuilderEntityLinkedSeat)this.entity.m_20202_()).entity = entityToRide;
            }
            this.cachedEntityRiding = entityToRide;
        } else {
            this.entity.m_8127_();
            this.cachedEntityRiding = null;
        }
    }

    @Override
    public double getVerticalScale() {
        PartSeat seat;
        AEntityB_Existing riding = this.getEntityRiding();
        if (riding instanceof PartSeat && (seat = (PartSeat)riding) != null) {
            if (seat.placementDefinition.playerScale != null) {
                if (((JSONPart)seat.definition).seat.playerScale != null) {
                    return seat.scale.y * seat.placementDefinition.playerScale.y * ((JSONPart)seat.definition).seat.playerScale.y;
                }
                return seat.scale.y * seat.placementDefinition.playerScale.y;
            }
            if (((JSONPart)seat.definition).seat.playerScale != null) {
                return seat.scale.y * ((JSONPart)seat.definition).seat.playerScale.y;
            }
            return seat.scale.y;
        }
        return 1.0;
    }

    @Override
    public double getSeatOffset() {
        AEntityB_Existing riding = this.getEntityRiding();
        if (riding instanceof PartSeat && !((JSONPart)((PartSeat)riding).definition).seat.standing) {
            if (this.entity instanceof Animal) {
                return this.entity.m_6049_() - 0.14;
            }
            if (this.entity instanceof Villager) {
                return -0.703125;
            }
            ResourceLocation registration = ForgeRegistries.ENTITY_TYPES.getKey((Object)this.entity.m_6095_());
            if (registration != null && registration.m_135827_().equals("customnpcs")) {
                return -0.2;
            }
            return this.entity.m_6049_();
        }
        return 0.0;
    }

    @Override
    public double getEyeHeight() {
        return this.entity.m_20192_();
    }

    @Override
    public Point3D getPosition() {
        this.mutablePosition.set(this.entity.m_20185_(), this.entity.m_20186_(), this.entity.m_20189_());
        return this.mutablePosition;
    }

    @Override
    public Point3D getEyePosition() {
        AEntityB_Existing riding = this.getEntityRiding();
        return riding != null ? riding.riderEyePosition : this.getPosition().add(0.0, this.getEyeHeight() + this.getSeatOffset(), 0.0);
    }

    @Override
    public Point3D getHeadPosition() {
        AEntityB_Existing riding = this.getEntityRiding();
        return riding != null ? riding.riderHeadPosition : this.getPosition().add(0.0, this.getEyeHeight() + this.getSeatOffset(), 0.0);
    }

    @Override
    public void setPosition(Point3D position, boolean onGround) {
        if (this.cachedEntityRiding != null) {
            this.entity.m_6034_(position.x, position.y + this.getSeatOffset(), position.z);
        } else {
            Point3D point3D = new Point3D(this.entity.m_20185_(), this.entity.m_20186_(), this.entity.m_20189_());
            if (position.distanceTo(point3D) < 0.25) {
                this.entity.m_6034_(position.x, position.y, position.z);
            } else {
                this.entity.m_6021_(position.x, position.y, position.z);
            }
        }
        this.entity.f_19789_ = 0.0f;
        this.entity.m_6853_(onGround);
    }

    @Override
    public void applyMotion(Point3D motion) {
        this.entity.m_5997_(motion.x, motion.y, motion.z);
        this.entity.f_19864_ = true;
    }

    @Override
    public Point3D getVelocity() {
        this.mutableVelocity.set(this.entity.m_20184_().f_82479_, this.entity.m_20096_() ? 0.0 : this.entity.m_20184_().f_82480_, this.entity.m_20184_().f_82481_);
        return this.mutableVelocity;
    }

    @Override
    public void setVelocity(Point3D motion) {
        this.entity.m_20334_(motion.x, motion.y, motion.z);
    }

    @Override
    public RotationMatrix getOrientation() {
        float pitchChecked = this.entity.m_146909_();
        float yawChecked = this.entity.m_146908_();
        if (this.lastPitchChecked != pitchChecked || this.lastYawChecked != yawChecked) {
            this.lastPitchChecked = pitchChecked;
            this.lastYawChecked = yawChecked;
            this.mutableOrientation.angles.set(this.lastPitchChecked, -this.lastYawChecked, 0.0);
            this.mutableOrientation.setToAngles(this.mutableOrientation.angles);
        }
        return this.mutableOrientation;
    }

    @Override
    public void setOrientation(RotationMatrix rotation) {
        if (this.entity.m_9236_().f_46443_) {
            float yawDelta = ((float)(-rotation.angles.y) - this.lastYawApplied) % 360.0f;
            if (yawDelta > 180.0f) {
                yawDelta -= 360.0f;
            } else if (yawDelta < -180.0f) {
                yawDelta -= 360.0f;
            }
            this.entity.m_146922_(this.lastYawApplied + yawDelta);
            this.lastYawApplied += yawDelta;
        } else {
            this.entity.m_146922_((float)(-rotation.angles.y));
        }
        this.entity.m_146926_((float)rotation.angles.x);
    }

    @Override
    public float getPitch() {
        return this.entity.m_146909_();
    }

    @Override
    public float getPitchDelta() {
        float currentPitch = this.entity.m_146909_();
        float value = currentPitch - this.lastPitch;
        this.lastPitch = currentPitch;
        return value;
    }

    @Override
    public float getYaw() {
        return -this.entity.m_146908_();
    }

    @Override
    public float getYawDelta() {
        float currentYaw = this.entity.m_146908_();
        float value = currentYaw - this.lastYaw;
        this.lastYaw = currentYaw;
        return -value;
    }

    @Override
    public float getBodyYaw() {
        return this.entity instanceof LivingEntity ? -((LivingEntity)this.entity).f_20883_ : 0.0f;
    }

    @Override
    public Point3D getLineOfSight(double distance) {
        this.mutableSight.set(0.0, 0.0, distance).rotate(this.getOrientation());
        return this.mutableSight;
    }

    @Override
    public void setYaw(double yaw) {
        this.entity.m_146922_((float)(-yaw));
    }

    @Override
    public void setBodyYaw(double yaw) {
        if (this.entity instanceof LivingEntity) {
            this.entity.m_5618_((float)(-yaw));
        }
    }

    @Override
    public void setPitch(double pitch) {
        this.entity.m_146926_((float)pitch);
    }

    @Override
    public BoundingBox getBounds() {
        this.mutableBounds.widthRadius = this.entity.m_20205_() / 2.0f;
        this.mutableBounds.heightRadius = this.entity.m_20206_() / 2.0f;
        this.mutableBounds.depthRadius = this.entity.m_20205_() / 2.0f;
        this.mutableBounds.globalCenter.set(this.entity.m_20185_(), this.entity.m_20186_() + this.mutableBounds.heightRadius, this.entity.m_20189_());
        return this.mutableBounds;
    }

    @Override
    public IWrapperNBT getData() {
        CompoundTag tag = new CompoundTag();
        this.entity.m_20223_(tag);
        return new WrapperNBT(tag);
    }

    @Override
    public void setData(IWrapperNBT data) {
        this.entity.m_20258_(((WrapperNBT)data).tag);
    }

    @Override
    public boolean leashTo(IWrapperPlayer player) {
        Player mcPlayer = ((WrapperPlayer)player).player;
        if (this.entity instanceof Mob) {
            ItemStack heldStack = mcPlayer.m_21205_();
            if (((Mob)this.entity).m_6573_(mcPlayer) && heldStack.m_41720_() instanceof LeadItem) {
                ((Mob)this.entity).m_21463_((Entity)mcPlayer, true);
                if (!mcPlayer.m_7500_()) {
                    heldStack.m_41774_(1);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void attack(final Damage damage) {
        if (damage.language == null) {
            throw new IllegalArgumentException("ERROR: Cannot attack an entity with a damage of no type and language component!");
        }
        HashSet<TagKey> damageTags = new HashSet<TagKey>();
        if (damage.isFire) {
            damageTags.add(DamageTypeTags.f_268745_);
        }
        if (damage.isExplosion) {
            damageTags.add(DamageTypeTags.f_268415_);
        }
        if (damage.ignoreArmor) {
            damageTags.add(DamageTypeTags.f_268490_);
        }
        if (((Boolean)ConfigSystem.settings.damage.creativePlayerDamage.value).booleanValue()) {
            damageTags.add(DamageTypeTags.f_268738_);
        }
        Holder damageHolder = (Holder)this.entity.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_203636_(DamageTypes.f_268433_).get();
        DamageSource newSource = new DamageSource(damageHolder, damage.entityResponsible != null ? ((WrapperEntity)damage.entityResponsible).entity : null){

            public Component m_6157_(LivingEntity player) {
                if (damage.entityResponsible != null) {
                    return Component.m_237113_((String)String.format(damage.language.getCurrentValue(), player.m_5446_().getString(), ((WrapperEntity)damage.entityResponsible).entity.m_5446_().getString()));
                }
                return Component.m_237113_((String)String.format(damage.language.getCurrentValue(), player.m_5446_().getString()));
            }
        };
        if (damage.isFire) {
            this.entity.m_7311_(5);
        }
        if (damage.knockback != null) {
            this.applyMotion(damage.knockback);
        }
        if (damage.isWater) {
            this.entity.m_20095_();
            return;
        }
        if (damage.ignoreCooldown && this.entity instanceof LivingEntity) {
            this.entity.f_19802_ = 0;
        }
        this.entity.m_6469_(newSource, (float)damage.amount);
        if (damage.effects != null) {
            damage.effects.forEach(effect -> this.addPotionEffect((JSONPotionEffect)effect));
        }
    }

    @Override
    public void addPotionEffect(JSONPotionEffect effect) {
        if (this.entity instanceof LivingEntity) {
            Potion potion = Potion.m_43489_((String)effect.name);
            if (potion != null) {
                potion.m_43488_().forEach(mcEffect -> ((LivingEntity)this.entity).m_7292_(new MobEffectInstance(mcEffect.m_19544_(), effect.duration, effect.amplifier, false, false)));
            } else {
                throw new NullPointerException("Potion " + effect.name + " does not exist.");
            }
        }
    }

    @Override
    public void removePotionEffect(JSONPotionEffect effect) {
        if (this.entity instanceof LivingEntity) {
            Potion potion = Potion.m_43489_((String)effect.name);
            if (potion != null) {
                potion.m_43488_().forEach(mcEffect -> ((LivingEntity)this.entity).m_21195_(mcEffect.m_19544_()));
            } else {
                throw new NullPointerException("Potion " + effect.name + " does not exist.");
            }
        }
    }

    @SubscribeEvent
    public static void onIVWorldUnload(LevelEvent.Unload event) {
        if (event.getLevel().m_5776_()) {
            entityClientWrappers.keySet().removeIf(entity1 -> event.getLevel() == entity1.m_9236_());
        } else {
            entityServerWrappers.keySet().removeIf(entity1 -> event.getLevel() == entity1.m_9236_());
        }
    }
}

